/* Copyright (c) 2014 Synology Inc. All rights reserved. */

ace.define("ace/mode/ejs",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/javascript_highlight_rules","ace/tokenizer","ace/mode/html","ace/mode/javascript","ace/mode/css","ace/mode/ruby"],function(c,e,a){var h=c("../lib/oop");var d=c("./html_highlight_rules").HtmlHighlightRules;var g=c("./javascript_highlight_rules").JavaScriptHighlightRules;var m=function(p,n){d.call(this);if(!p){p="(?:<%|<\\?|{{)"}if(!n){n="(?:%>|\\?>|}})"}for(var o in this.$rules){this.$rules[o].unshift({token:"markup.list.meta.tag",regex:p+"(?![>}])[-=]?",push:"ejs-start"})}this.embedRules(g,"ejs-");this.$rules["ejs-start"].unshift({token:"markup.list.meta.tag",regex:"-?"+n,next:"pop"},{token:"comment",regex:"//.*?"+n,next:"pop"});this.$rules["ejs-no_regex"].unshift({token:"markup.list.meta.tag",regex:"-?"+n,next:"pop"},{token:"comment",regex:"//.*?"+n,next:"pop"});this.normalizeRules()};h.inherits(m,d);e.EjsHighlightRules=m;var h=c("../lib/oop");var i=c("../tokenizer").Tokenizer;var j=c("./html").Mode;var l=c("./javascript").Mode;var f=c("./css").Mode;var b=c("./ruby").Mode;var k=function(){j.call(this);this.HighlightRules=m;this.createModeDelegates({"js-":l,"css-":f,"ejs-":l})};h.inherits(k,j);(function(){this.$id="ace/mode/ejs"}).call(k.prototype);e.Mode=k});ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(d,g,c){var j=d("../lib/oop");var b=d("../lib/lang");var h=d("./css_highlight_rules").CssHighlightRules;var i=d("./javascript_highlight_rules").JavaScriptHighlightRules;var a=d("./xml_highlight_rules").XmlHighlightRules;var f=b.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"});var e=function(){a.call(this);this.addRules({attributes:[{include:"space"},{token:"entity.other.attribute-name",regex:"[-_a-zA-Z0-9:]+"},{token:"keyword.operator.separator",regex:"=",push:[{include:"space"},{token:"string",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"string"}],tag:[{token:function(m,k){var l=f[k];return["meta.tag.punctuation.begin","meta.tag.name"+(l?"."+l:"")]},regex:"(<)([-_a-zA-Z0-9:]+)",next:"start_tag_stuff"},{token:function(m,k){var l=f[k];return["meta.tag.punctuation.begin","meta.tag.name"+(l?"."+l:"")]},regex:"(</)([-_a-zA-Z0-9:]+)",next:"end_tag_stuff"}],start_tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.end",regex:"/?>",next:"start"}],end_tag_stuff:[{include:"space"},{token:"meta.tag.punctuation.end",regex:">",next:"start"}]});this.embedTagRules(h,"css-","style");this.embedTagRules(i,"js-","script");if(this.constructor===e){this.normalizeRules()}};j.inherits(e,a);g.HtmlHighlightRules=e});ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(f,h,c){var m=f("../lib/oop");var b=f("../lib/lang");var a=f("./text_highlight_rules").TextHighlightRules;var k=h.supportType="animation-fill-mode|alignment-adjust|alignment-baseline|animation-delay|animation-direction|animation-duration|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|animation|appearance|azimuth|backface-visibility|background-attachment|background-break|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|background|baseline-shift|binding|bleed|bookmark-label|bookmark-level|bookmark-state|bookmark-target|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|border|bottom|box-align|box-decoration-break|box-direction|box-flex-group|box-flex|box-lines|box-ordinal-group|box-orient|box-pack|box-shadow|box-sizing|break-after|break-before|break-inside|caption-side|clear|clip|color-profile|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|crop|cue-after|cue-before|cue|cursor|direction|display|dominant-baseline|drop-initial-after-adjust|drop-initial-after-align|drop-initial-before-adjust|drop-initial-before-align|drop-initial-size|drop-initial-value|elevation|empty-cells|fit|fit-position|float-offset|float|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|font|grid-columns|grid-rows|hanging-punctuation|height|hyphenate-after|hyphenate-before|hyphenate-character|hyphenate-lines|hyphenate-resource|hyphens|icon|image-orientation|image-rendering|image-resolution|inline-box-align|left|letter-spacing|line-height|line-stacking-ruby|line-stacking-shift|line-stacking-strategy|line-stacking|list-style-image|list-style-position|list-style-type|list-style|margin-bottom|margin-left|margin-right|margin-top|margin|mark-after|mark-before|mark|marks|marquee-direction|marquee-play-count|marquee-speed|marquee-style|max-height|max-width|min-height|min-width|move-to|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|orphans|outline-color|outline-offset|outline-style|outline-width|outline|overflow-style|overflow-x|overflow-y|overflow|padding-bottom|padding-left|padding-right|padding-top|padding|page-break-after|page-break-before|page-break-inside|page-policy|page|pause-after|pause-before|pause|perspective-origin|perspective|phonemes|pitch-range|pitch|play-during|pointer-events|position|presentation-level|punctuation-trim|quotes|rendering-intent|resize|rest-after|rest-before|rest|richness|right|rotation-point|rotation|ruby-align|ruby-overhang|ruby-position|ruby-span|size|speak-header|speak-numeral|speak-punctuation|speak|speech-rate|stress|string-set|table-layout|target-name|target-new|target-position|target|text-align-last|text-align|text-decoration|text-emphasis|text-height|text-indent|text-justify|text-outline|text-shadow|text-transform|text-wrap|top|transform-origin|transform-style|transform|transition-delay|transition-duration|transition-property|transition-timing-function|transition|unicode-bidi|vertical-align|visibility|voice-balance|voice-duration|voice-family|voice-pitch-range|voice-pitch|voice-rate|voice-stress|voice-volume|volume|white-space-collapse|white-space|widows|width|word-break|word-spacing|word-wrap|z-index";var g=h.supportFunction="rgb|rgba|url|attr|counter|counters";var l=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero";var o=h.supportConstantColor="aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow";var e=h.supportConstantFonts="arial|century|comic|courier|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";var n=h.numRe="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";var j=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var d=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";var i=function(){var p=this.createKeywordMapper({"support.function":g,"support.constant":l,"support.type":k,"support.constant.color":o,"support.constant.fonts":e},"text",true);this.$rules={start:[{token:"comment",regex:"\\/\\*",push:"comment"},{token:"paren.lparen",regex:"\\{",push:"ruleset"},{token:"string",regex:"@.*?{",push:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:true}],media:[{token:"comment",regex:"\\/\\*",push:"comment"},{token:"paren.lparen",regex:"\\{",push:"ruleset"},{token:"string",regex:"\\}",next:"pop"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:true}],comment:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}],ruleset:[{token:"paren.rparen",regex:"\\}",next:"pop"},{token:"comment",regex:"\\/\\*",push:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:["constant.numeric","keyword"],regex:"("+n+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:"constant.numeric",regex:n},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:j},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:d},{token:["support.function","string","support.function"],regex:"(url\\()(.*)(\\))"},{token:p,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:true}]};this.normalizeRules()};m.inherits(i,a);h.CssHighlightRules=i});ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(c,b,e){var g=c("../lib/oop");var d=c("./doc_comment_highlight_rules").DocCommentHighlightRules;var a=c("./text_highlight_rules").TextHighlightRules;var f=function(){var i=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier");var k="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void";var h="[a-zA-Z\\$_\u00a1-\uffff][a-zA-Z\\d\\$_\u00a1-\uffff]*\\b";var j="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[{token:"comment",regex:"\\/\\/",next:"line_comment"},d.getStartRule("doc-start"),{token:"comment",regex:/\/\*/,next:"comment"},{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0[xX][0-9a-fA-F]+\b/},{token:"constant.numeric",regex:/[+-]?\d+(?:(?:\.\d*)?(?:[eE][+-]?\d+)?)?\b/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+h+")(\\.)(prototype)(\\.)("+h+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+h+")(\\.)("+h+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+h+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+h+")(\\.)("+h+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+h+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+h+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"(?:"+k+")\\b",next:"start"},{token:["punctuation.operator","support.function"],regex:/(\.)(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:["punctuation.operator","support.function.dom"],regex:/(\.)(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:["punctuation.operator","support.constant"],regex:/(\.)(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|timeEnd|assert)\b/},{token:i,regex:h},{token:"keyword.operator",regex:/--|\+\+|[!$%&*+\-~]|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\|\||\?\:|\*=|%=|\+=|\-=|&=|\^=/,next:"start"},{token:"punctuation.operator",regex:/\?|\:|\,|\;|\./,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"keyword.operator",regex:/\/=?/,next:"start"},{token:"comment",regex:/^#!.*$/}],start:[d.getStartRule("doc-start"),{token:"comment",regex:"\\/\\*",next:"comment_regex_allowed"},{token:"comment",regex:"\\/\\/",next:"line_comment_regex_allowed"},{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],function_arguments:[{token:"variable.parameter",regex:h},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],comment_regex_allowed:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}],comment:[{token:"comment",regex:"\\*\\/",next:"no_regex"},{defaultToken:"comment"}],line_comment_regex_allowed:[{token:"comment",regex:"$|^",next:"start"},{defaultToken:"comment"}],line_comment:[{token:"comment",regex:"$|^",next:"no_regex"},{defaultToken:"comment"}],qqstring:[{token:"constant.language.escape",regex:j},{token:"string",regex:"\\\\$",next:"qqstring"},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:j},{token:"string",regex:"\\\\$",next:"qstring"},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]};this.embedRules(d,"doc-",[d.getEndRule("no_regex")])};g.inherits(f,a);b.JavaScriptHighlightRules=f});ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,b,e){var f=c("../lib/oop");var a=c("./text_highlight_rules").TextHighlightRules;var d=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},{token:"comment.doc.tag",regex:"\\bTODO\\b"},{defaultToken:"comment.doc"}]}};f.inherits(d,a);d.getStartRule=function(g){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:g}};d.getEndRule=function(g){return{token:"comment.doc",regex:"\\*\\/",next:g}};b.DocCommentHighlightRules=d});ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/xml_util","ace/mode/text_highlight_rules"],function(d,c,e){var f=d("../lib/oop");var g=d("./xml_util");var b=d("./text_highlight_rules").TextHighlightRules;var a=function(h){this.$rules={start:[{token:"punctuation.string.begin",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.begin","keyword.instruction"],regex:"(<\\?)(xml)(?=[\\s])",next:"xml_declaration"},{token:["punctuation.instruction.begin","keyword.instruction"],regex:"(<\\?)([-_a-zA-Z0-9]+)",next:"instruction"},{token:"comment",regex:"<\\!--",next:"comment"},{token:["punctuation.doctype.begin","meta.tag.doctype"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype"},{include:"tag"},{include:"reference"}],xml_declaration:[{include:"attributes"},{include:"instruction"}],instruction:[{token:"punctuation.instruction.end",regex:"\\?>",next:"start"}],doctype:[{include:"space"},{include:"string"},{token:"punctuation.doctype.end",regex:">",next:"start"},{token:"xml-pe",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.begin",regex:"\\[",push:"declarations"}],declarations:[{token:"text",regex:"\\s+"},{token:"punctuation.end",regex:"]",next:"pop"},{token:["punctuation.begin","keyword"],regex:"(<\\!)([-_a-zA-Z0-9]+)",push:[{token:"text",regex:"\\s+"},{token:"punctuation.end",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.end",regex:"\\]\\]>",next:"start"},{token:"text",regex:"\\s+"},{token:"text",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment",regex:"-->",next:"start"},{defaultToken:"comment"}],tag:[{token:["meta.tag.punctuation.begin","meta.tag.name"],regex:"(<)((?:[-_a-zA-Z0-9]+:)?[-_a-zA-Z0-9]+)",next:[{include:"attributes"},{token:"meta.tag.punctuation.end",regex:"/?>",next:"start"}]},{token:["meta.tag.punctuation.begin","meta.tag.name"],regex:"(</)((?:[-_a-zA-Z0-9]+:)?[-_a-zA-Z0-9]+)",next:[{include:"space"},{token:"meta.tag.punctuation.end",regex:">",next:"start"}]}],space:[{token:"text",regex:"\\s+"}],reference:[{token:"constant.language.escape",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"},{token:"text",regex:"&"}],string:[{token:"string",regex:"'",push:"qstring_inner"},{token:"string",regex:'"',push:"qqstring_inner"}],qstring_inner:[{token:"string",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string"}],qqstring_inner:[{token:"string",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string"}],attributes:[{token:"entity.other.attribute-name",regex:"(?:[-_a-zA-Z0-9]+:)?[-_a-zA-Z0-9]+"},{token:"keyword.operator.separator",regex:"="},{include:"space"},{include:"string"}]};if(this.constructor===a){this.normalizeRules()}};(function(){this.embedTagRules=function(j,i,h){this.$rules.tag.unshift({token:["meta.tag.punctuation.begin","meta.tag.name."+h],regex:"(<)("+h+")",next:[{include:"space"},{include:"attributes"},{token:"meta.tag.punctuation.end",regex:"/?>",next:i+"start"}]});this.$rules[h+"-end"]=[{include:"space"},{token:"meta.tag.punctuation.end",regex:">",next:"start",onMatch:function(m,l,k){k.splice(0);return this.token}}];this.embedRules(j,i,[{token:["meta.tag.punctuation.begin","meta.tag.name."+h],regex:"(</)("+h+")",next:h+"-end"},{token:"string.begin",regex:"<\\!\\[CDATA\\["},{token:"string.end",regex:"\\]\\]>"}])}}).call(b.prototype);f.inherits(a,b);c.XmlHighlightRules=a});ace.define("ace/mode/xml_util",["require","exports","module"],function(d,b,e){function c(f){return[{token:"string",regex:'"',next:f+"_qqstring"},{token:"string",regex:"'",next:f+"_qstring"}]}function a(f,g){return[{token:"string",regex:f,next:g},{token:"constant.language.escape",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"},{defaultToken:"string"}]}b.tag=function(f,g,h,i){f[g]=[{token:"text",regex:"\\s+"},{token:!i?"meta.tag.tag-name":function(j){if(i[j]){return"meta.tag.tag-name."+i[j]}else{return"meta.tag.tag-name"}},regex:"[-_a-zA-Z0-9:]+",next:g+"_embed_attribute_list"},{token:"empty",regex:"",next:g+"_embed_attribute_list"}];f[g+"_qstring"]=a("'",g+"_embed_attribute_list");f[g+"_qqstring"]=a('"',g+"_embed_attribute_list");f[g+"_embed_attribute_list"]=[{token:"meta.tag.r",regex:"/?>",next:h},{token:"keyword.operator",regex:"="},{token:"entity.other.attribute-name",regex:"[-_a-zA-Z0-9:]+"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"text",regex:"\\s+"}].concat(c(g))}});ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/tokenizer","ace/mode/html_highlight_rules","ace/mode/behaviour/html","ace/mode/folding/html","ace/mode/html_completions"],function(c,f,a){var h=c("../lib/oop");var d=c("./text").Mode;var m=c("./javascript").Mode;var g=c("./css").Mode;var j=c("../tokenizer").Tokenizer;var e=c("./html_highlight_rules").HtmlHighlightRules;var i=c("./behaviour/html").HtmlBehaviour;var k=c("./folding/html").FoldMode;var b=c("./html_completions").HtmlCompletions;var l=function(){this.HighlightRules=e;this.$behaviour=new i();this.$completer=new b();this.createModeDelegates({"js-":m,"css-":g});this.foldingRules=new k()};h.inherits(l,d);(function(){this.blockComment={start:"<!--",end:"-->"};this.getNextLineIndent=function(p,n,o){return this.$getIndent(n)};this.checkOutdent=function(p,n,o){return false};this.getCompletions=function(o,p,q,n){return this.$completer.getCompletions(o,p,q,n)};this.$id="ace/mode/html"}).call(l.prototype);f.Mode=l});ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(d,f,b){var h=d("../lib/oop");var e=d("./text").Mode;var i=d("../tokenizer").Tokenizer;var g=d("./javascript_highlight_rules").JavaScriptHighlightRules;var k=d("./matching_brace_outdent").MatchingBraceOutdent;var c=d("../range").Range;var a=d("../worker/worker_client").WorkerClient;var l=d("./behaviour/cstyle").CstyleBehaviour;var m=d("./folding/cstyle").FoldMode;var j=function(){this.HighlightRules=g;this.$outdent=new k();this.$behaviour=new l();this.foldingRules=new m()};h.inherits(j,e);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(t,p,r){var o=this.$getIndent(p);var s=this.getTokenizer().getLineTokens(p,t);var u=s.tokens;var n=s.state;if(u.length&&u[u.length-1].type=="comment"){return o}if(t=="start"||t=="no_regex"){var q=p.match(/^.*(?:\bcase\b.*\:|[\{\(\[])\s*$/);if(q){o+=r}}else{if(t=="doc-start"){if(n=="start"||n=="no_regex"){return""}var q=p.match(/^\s*(\/?)\*/);if(q){if(q[1]){o+=" "}o+="* "}}}return o};this.checkOutdent=function(p,n,o){return this.$outdent.checkOutdent(n,o)};this.autoOutdent=function(n,o,p){this.$outdent.autoOutdent(o,p)};this.createWorker=function(n){var o=new a(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");o.attachToDocument(n.getDocument());o.on("jslint",function(p){n.setAnnotations(p.data)});o.on("terminate",function(){n.clearAnnotations()});return o};this.$id="ace/mode/javascript"}).call(j.prototype);f.Mode=j});ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(c,b,d){var e=c("../range").Range;var a=function(){};(function(){this.checkOutdent=function(f,g){if(!/^\s+$/.test(f)){return false}return/^\s*\}/.test(g)};this.autoOutdent=function(k,l){var g=k.getLine(l);var h=g.match(/^(\s*\})/);if(!h){return 0}var i=h[1].length;var j=k.findMatchingBracket({row:l,column:i});if(!j||j.row==l){return 0}var f=this.$getIndent(k.getLine(j.row));k.replace(new e(l,0,l,i-1),f)};this.$getIndent=function(f){return f.match(/^\s*/)[0]}}).call(a.prototype);b.MatchingBraceOutdent=a});ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,h,c){var k=e("../../lib/oop");var f=e("../behaviour").Behaviour;var n=e("../../token_iterator").TokenIterator;var b=e("../../lib/lang");var j=["text","paren.rparen","punctuation.operator"];var d=["text","paren.rparen","punctuation.operator","comment"];var m=0;var a=-1;var o="";var g=0;var i=-1;var l="";var p="";var q=function(){q.isSaneInsertion=function(t,u){var v=t.getCursorPosition();var s=new n(u,v.row,v.column);if(!this.$matchTokenType(s.getCurrentToken()||"text",j)){var r=new n(u,v.row,v.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",j)){return false}}s.stepForward();return s.getCurrentTokenRow()!==v.row||this.$matchTokenType(s.getCurrentToken()||"text",d)};q.$matchTokenType=function(s,r){return r.indexOf(s.type||s)>-1};q.recordAutoInsert=function(s,t,v){var u=s.getCursorPosition();var r=t.doc.getLine(u.row);if(!this.isAutoInsertedClosing(u,r,o[0])){m=0}a=u.row;o=v+r.substr(u.column);m++};q.recordMaybeInsert=function(s,t,v){var u=s.getCursorPosition();var r=t.doc.getLine(u.row);if(!this.isMaybeInsertedClosing(u,r)){g=0}i=u.row;l=r.substr(0,u.column)+v;p=r.substr(u.column);g++};q.isAutoInsertedClosing=function(t,r,s){return m>0&&t.row===a&&s===o[0]&&r.substr(t.column)===o};q.isMaybeInsertedClosing=function(s,r){return g>0&&s.row===i&&r.substr(s.column)===p&&r.substr(0,s.column)==l};q.popAutoInsertedClosing=function(){o=o.substr(1);m--};q.clearMaybeInsertedClosing=function(){g=0;i=-1};this.add("braces","insertion",function(s,v,y,B,D){var E=y.getCursorPosition();var F=B.doc.getLine(E.row);if(D=="{"){var C=y.getSelectionRange();var w=B.doc.getTextRange(C);if(w!==""&&w!=="{"&&y.getWrapBehavioursEnabled()){return{text:"{"+w+"}",selection:false}}else{if(q.isSaneInsertion(y,B)){if(/[\]\}\)]/.test(F[E.column])||y.inMultiSelectMode){q.recordAutoInsert(y,B,"}");return{text:"{}",selection:[1,1]}}else{q.recordMaybeInsert(y,B,"{");return{text:"{",selection:[1,1]}}}}}else{if(D=="}"){var z=F.substring(E.column,E.column+1);if(z=="}"){var r=B.$findOpeningBracket("}",{column:E.column+1,row:E.row});if(r!==null&&q.isAutoInsertedClosing(E,F,D)){q.popAutoInsertedClosing();return{text:"",selection:[1,1]}}}}else{if(D=="\n"||D=="\r\n"){var u="";if(q.isMaybeInsertedClosing(E,F)){u=b.stringRepeat("}",g);q.clearMaybeInsertedClosing()}var z=F.substring(E.column,E.column+1);if(z==="}"){var A=B.findMatchingBracket({row:E.row,column:E.column+1},"}");if(!A){return null}var x=this.$getIndent(B.getLine(A.row))}else{if(u){var x=this.$getIndent(F)}else{return}}var t=x+B.getTabString();return{text:"\n"+t+"\n"+x+u,selection:[1,t.length,1,t.length]}}else{q.clearMaybeInsertedClosing()}}}});this.add("braces","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&t=="{"){var r=x.doc.getLine(s.start.row);var y=r.substring(s.end.column,s.end.column+1);if(y=="}"){s.end.column++;return s}else{g--}}});this.add("parens","insertion",function(s,t,v,x,z){if(z=="("){var y=v.getSelectionRange();var u=x.doc.getTextRange(y);if(u!==""&&v.getWrapBehavioursEnabled()){return{text:"("+u+")",selection:false}}else{if(q.isSaneInsertion(v,x)){q.recordAutoInsert(v,x,")");return{text:"()",selection:[1,1]}}}}else{if(z==")"){var A=v.getCursorPosition();var B=x.doc.getLine(A.row);var w=B.substring(A.column,A.column+1);if(w==")"){var r=x.$findOpeningBracket(")",{column:A.column+1,row:A.row});if(r!==null&&q.isAutoInsertedClosing(A,B,z)){q.popAutoInsertedClosing();return{text:"",selection:[1,1]}}}}}});this.add("parens","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&t=="("){var r=x.doc.getLine(s.start.row);var y=r.substring(s.start.column+1,s.start.column+2);if(y==")"){s.end.column++;return s}}});this.add("brackets","insertion",function(s,t,v,x,z){if(z=="["){var y=v.getSelectionRange();var u=x.doc.getTextRange(y);if(u!==""&&v.getWrapBehavioursEnabled()){return{text:"["+u+"]",selection:false}}else{if(q.isSaneInsertion(v,x)){q.recordAutoInsert(v,x,"]");return{text:"[]",selection:[1,1]}}}}else{if(z=="]"){var A=v.getCursorPosition();var B=x.doc.getLine(A.row);var w=B.substring(A.column,A.column+1);if(w=="]"){var r=x.$findOpeningBracket("]",{column:A.column+1,row:A.row});if(r!==null&&q.isAutoInsertedClosing(A,B,z)){q.popAutoInsertedClosing();return{text:"",selection:[1,1]}}}}}});this.add("brackets","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&t=="["){var r=x.doc.getLine(s.start.row);var y=r.substring(s.start.column+1,s.start.column+2);if(y=="]"){s.end.column++;return s}}});this.add("string_dquotes","insertion",function(s,v,z,C,G){if(G=='"'||G=="'"){var r=G;var E=z.getSelectionRange();var w=C.doc.getTextRange(E);if(w!==""&&w!=="'"&&w!='"'&&z.getWrapBehavioursEnabled()){return{text:r+w+r,selection:false}}else{var F=z.getCursorPosition();var I=C.doc.getLine(F.row);var H=I.substring(F.column-1,F.column);if(H=="\\"){return null}var B=C.getTokens(E.start.row);var t=0,u;var y=-1;for(var D=0;D<B.length;D++){u=B[D];if(u.type=="string"){y=-1}else{if(y<0){y=u.value.indexOf(r)}}if((u.value.length+t)>E.start.column){break}t+=B[D].value.length}if(!u||(y<0&&u.type!=="comment"&&(u.type!=="string"||((E.start.column!==u.value.length+t-1)&&u.value.lastIndexOf(r)===u.value.length-1)))){if(!q.isSaneInsertion(z,C)){return}return{text:r+r,selection:[1,1]}}else{if(u&&u.type==="string"){var A=I.substring(F.column,F.column+1);if(A==r){return{text:"",selection:[1,1]}}}}}}});this.add("string_dquotes","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&(t=='"'||t=="'")){var r=x.doc.getLine(s.start.row);var y=r.substring(s.start.column+1,s.start.column+2);if(y==t){s.end.column++;return s}}})};k.inherits(q,f);h.CstyleBehaviour=q});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(b,a,c){var d=b("../../lib/oop");var f=b("../../range").Range;var g=b("./fold_mode").FoldMode;var e=a.FoldMode=function(h){if(h){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+h.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+h.end))}};d.inherits(e,g);(function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;this.getFoldWidgetRange=function(o,n,p,m){var h=o.getLine(p);var k=h.match(this.foldingStartMarker);if(k){var l=k.index;if(k[1]){return this.openingBracketBlock(o,k[1],p,l)}var j=o.getCommentFoldRange(p,l+k[0].length,1);if(j&&!j.isMultiLine()){if(m){j=this.getSectionRange(o,p)}else{if(n!="all"){j=null}}}return j}if(n==="markbegin"){return}var k=h.match(this.foldingStopMarker);if(k){var l=k.index+k[0].length;if(k[1]){return this.closingBracketBlock(o,k[1],p,l)}return o.getCommentFoldRange(p,l,-1)}};this.getSectionRange=function(m,p){var q=m.getLine(p);var i=q.search(/\S/);var o=p;var k=q.length;p=p+1;var l=p;var n=m.getLength();while(++p<n){q=m.getLine(p);var h=q.search(/\S/);if(h===-1){continue}if(i>h){break}var j=this.getFoldWidgetRange(m,"all",p);if(j){if(j.start.row<=o){break}else{if(j.isMultiLine()){p=j.end.row}else{if(i==h){break}}}}l=p}return new f(o,k,l,m.getLine(l).length)}}).call(e.prototype)});ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(c,e,b){var g=c("../lib/oop");var d=c("./text").Mode;var h=c("../tokenizer").Tokenizer;var f=c("./css_highlight_rules").CssHighlightRules;var j=c("./matching_brace_outdent").MatchingBraceOutdent;var a=c("../worker/worker_client").WorkerClient;var l=c("./behaviour/css").CssBehaviour;var k=c("./folding/cstyle").FoldMode;var i=function(){this.HighlightRules=f;this.$outdent=new j();this.$behaviour=new l();this.foldingRules=new k()};g.inherits(i,d);(function(){this.foldingRules="cStyle";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(q,n,p){var m=this.$getIndent(n);var r=this.getTokenizer().getLineTokens(n,q).tokens;if(r.length&&r[r.length-1].type=="comment"){return m}var o=n.match(/^.*\{\s*$/);if(o){m+=p}return m};this.checkOutdent=function(o,m,n){return this.$outdent.checkOutdent(m,n)};this.autoOutdent=function(m,n,o){this.$outdent.autoOutdent(n,o)};this.createWorker=function(m){var n=new a(["ace"],"ace/mode/css_worker","Worker");n.attachToDocument(m.getDocument());n.on("csslint",function(o){m.setAnnotations(o.data)});n.on("terminate",function(){m.clearAnnotations()});return n};this.$id="ace/mode/css"}).call(i.prototype);e.Mode=i});ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(d,b,e){var g=d("../../lib/oop");var h=d("../behaviour").Behaviour;var c=d("./cstyle").CstyleBehaviour;var f=d("../../token_iterator").TokenIterator;var a=function(){this.inherit(c);this.add("colon","insertion",function(i,k,m,o,p){if(p===":"){var q=m.getCursorPosition();var l=new f(o,q.row,q.column);var j=l.getCurrentToken();if(j&&j.value.match(/\s+/)){j=l.stepBackward()}if(j&&j.type==="support.type"){var r=o.doc.getLine(q.row);var n=r.substring(q.column,q.column+1);if(n===":"){return{text:"",selection:[1,1]}}if(!r.substring(q.column).match(/^\s*;/)){return{text:":;",selection:[1,1]}}}}});this.add("colon","deletion",function(i,k,o,q,n){var l=q.doc.getTextRange(n);if(!n.isMultiLine()&&l===":"){var r=o.getCursorPosition();var m=new f(q,r.row,r.column);var j=m.getCurrentToken();if(j&&j.value.match(/\s+/)){j=m.stepBackward()}if(j&&j.type==="support.type"){var s=q.doc.getLine(n.start.row);var p=s.substring(n.end.column,n.end.column+1);if(p===";"){n.end.column++;return n}}}});this.add("semicolon","insertion",function(l,k,j,m,o){if(o===";"){var n=j.getCursorPosition();var i=m.doc.getLine(n.row);var p=i.substring(n.column,n.column+1);if(p===";"){return{text:"",selection:[1,1]}}}})};g.inherits(a,c);b.CssBehaviour=a});ace.define("ace/mode/behaviour/html",["require","exports","module","ace/lib/oop","ace/mode/behaviour/xml","ace/mode/behaviour/cstyle","ace/token_iterator"],function(d,e,b){var f=d("../../lib/oop");var a=d("../behaviour/xml").XmlBehaviour;var j=d("./cstyle").CstyleBehaviour;var i=d("../../token_iterator").TokenIterator;var h=["area","base","br","col","command","embed","hr","img","input","keygen","link","meta","param","source","track","wbr"];function c(l,m){var k=l.type.split(".");return m.split(".").every(function(n){return(k.indexOf(n)!==-1)});return c}var g=function(){this.inherit(a);this.add("autoclosing","insertion",function(k,m,r,s,t){if(t==">"){var p=r.getCursorPosition();var o=new i(s,p.row,p.column);var l=o.getCurrentToken();if(l&&c(l,"string")&&o.getCurrentTokenColumn()+l.value.length>p.column){return}var q=false;if(!l||!c(l,"meta.tag")&&!(c(l,"text")&&l.value.match("/"))){do{l=o.stepBackward()}while(l&&(c(l,"string")||c(l,"keyword.operator")||c(l,"entity.attribute-name")||c(l,"text")))}else{q=true}if(!l||!c(l,"meta.tag.name")||o.stepBackward().value.match("/")){return}var n=l.value;if(q){var n=n.substring(0,p.column-l.start)}if(h.indexOf(n)!==-1){return}return{text:"></"+n+">",selection:[1,1]}}})};f.inherits(g,a);e.HtmlBehaviour=g});ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(c,f,b){var g=c("../../lib/oop");var e=c("../behaviour").Behaviour;var i=c("./cstyle").CstyleBehaviour;var h=c("../../token_iterator").TokenIterator;function d(k,l){var j=k.type.split(".");return l.split(".").every(function(m){return(j.indexOf(m)!==-1)});return d}var a=function(){this.inherit(i,["string_dquotes"]);this.add("autoclosing","insertion",function(j,l,p,q,r){if(r==">"){var n=p.getCursorPosition();var m=new h(q,n.row,n.column);var k=m.getCurrentToken();if(k&&d(k,"string")&&m.getCurrentTokenColumn()+k.value.length>n.column){return}var o=false;if(!k||!d(k,"meta.tag")&&!(d(k,"text")&&k.value.match("/"))){do{k=m.stepBackward()}while(k&&(d(k,"string")||d(k,"keyword.operator")||d(k,"entity.attribute-name")||d(k,"text")))}else{o=true}if(!k||!d(k,"meta.tag.name")||m.stepBackward().value.match("/")){return}var s=k.value;if(o){var s=s.substring(0,n.column-k.start)}return{text:"></"+s+">",selection:[1,1]}}});this.add("autoindent","insertion",function(j,m,o,p,q){if(q=="\n"){var r=o.getCursorPosition();var s=p.getLine(r.row);var l=s.substring(r.column,r.column+2);if(l=="</"){var n=this.$getIndent(s);var k=n+p.getTabString();return{text:"\n"+k+"\n"+n,selection:[1,k.length,1,k.length]}}}})};g.inherits(a,e);f.XmlBehaviour=a});ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(c,b,d){var f=c("../../lib/oop");var h=c("./mixed").FoldMode;var e=c("./xml").FoldMode;var a=c("./cstyle").FoldMode;var g=b.FoldMode=function(){h.call(this,new e({area:1,base:1,br:1,col:1,command:1,embed:1,hr:1,img:1,input:1,keygen:1,link:1,meta:1,param:1,source:1,track:1,wbr:1,li:1,dt:1,dd:1,p:1,rt:1,rp:1,optgroup:1,option:1,colgroup:1,td:1,th:1}),{"js-":new a(),"css-":new a()})};f.inherits(g,h)});ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(b,a,c){var d=b("../../lib/oop");var f=b("./fold_mode").FoldMode;var e=a.FoldMode=function(g,h){this.defaultMode=g;this.subModes=h};d.inherits(e,f);(function(){this.$getMode=function(h){if(typeof h!="string"){h=h[0]}for(var g in this.subModes){if(h.indexOf(g)===0){return this.subModes[g]}}return null};this.$tryMode=function(g,i,h,k){var j=this.$getMode(g);return(j?j.getFoldWidget(i,h,k):"")};this.getFoldWidget=function(h,g,i){return(this.$tryMode(h.getState(i-1),h,g,i)||this.$tryMode(h.getState(i),h,g,i)||this.defaultMode.getFoldWidget(h,g,i))};this.getFoldWidgetRange=function(h,g,j){var i=this.$getMode(h.getState(j-1));if(!i||!i.getFoldWidget(h,g,j)){i=this.$getMode(h.getState(j))}if(!i||!i.getFoldWidget(h,g,j)){i=this.defaultMode}return i.getFoldWidgetRange(h,g,j)}}).call(e.prototype)});ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(e,f,c){var g=e("../../lib/oop");var b=e("../../lib/lang");var d=e("../../range").Range;var i=e("./fold_mode").FoldMode;var h=e("../../token_iterator").TokenIterator;var a=f.FoldMode=function(j){i.call(this);this.voidElements=j||{}};g.inherits(a,i);(function(){this.getFoldWidget=function(l,k,m){var j=this._getFirstTagInLine(l,m);if(j.closing){return k=="markbeginend"?"end":""}if(!j.tagName||this.voidElements[j.tagName.toLowerCase()]){return""}if(j.selfClosing){return""}if(j.value.indexOf("/"+j.tagName)!==-1){return""}return"start"};this._getFirstTagInLine=function(n,o){var m=n.getTokens(o);var l="";for(var k=0;k<m.length;k++){var j=m[k];if(j.type.lastIndexOf("meta.tag",0)===0){l+=j.value}else{l+=b.stringRepeat(" ",j.value.length)}}return this._parseTag(l)};this.tagRe=/^(\s*)(<?(\/?)([-_a-zA-Z0-9:!]*)\s*(\/?)>?)/;this._parseTag=function(j){var k=j.match(this.tagRe);var l=0;return{value:j,match:k?k[2]:"",closing:k?!!k[3]:false,selfClosing:k?!!k[5]||k[2]=="/>":false,tagName:k?k[4]:"",column:k[1]?l+k[1].length:l}};this._readTagForward=function(l){var k=l.getCurrentToken();if(!k){return null}var m="";var n;do{if(k.type.lastIndexOf("meta.tag",0)===0){if(!n){var n={row:l.getCurrentTokenRow(),column:l.getCurrentTokenColumn()}}m+=k.value;if(m.indexOf(">")!==-1){var j=this._parseTag(m);j.start=n;j.end={row:l.getCurrentTokenRow(),column:l.getCurrentTokenColumn()+k.value.length};l.stepForward();return j}}}while(k=l.stepForward());return null};this._readTagBackward=function(m){var l=m.getCurrentToken();if(!l){return null}var n="";var k;do{if(l.type.lastIndexOf("meta.tag",0)===0){if(!k){k={row:m.getCurrentTokenRow(),column:m.getCurrentTokenColumn()+l.value.length}}n=l.value+n;if(n.indexOf("<")!==-1){var j=this._parseTag(n);j.end=k;j.start={row:m.getCurrentTokenRow(),column:m.getCurrentTokenColumn()};m.stepBackward();return j}}}while(l=m.stepBackward());return null};this._pop=function(k,j){while(k.length){var l=k[k.length-1];if(!j||l.tagName==j.tagName){return k.pop()}else{if(this.voidElements[j.tagName]){return}else{if(this.voidElements[l.tagName]){k.pop();continue}else{return null}}}}};this.getFoldWidgetRange=function(o,m,r){var l=this._getFirstTagInLine(o,r);if(!l.match){return null}var p=l.closing||l.selfClosing;var q=[];var s;if(!p){var n=new h(o,r,l.column);var j={row:r,column:l.column+l.tagName.length+2};while(s=this._readTagForward(n)){if(s.selfClosing){if(!q.length){s.start.column+=s.tagName.length+2;s.end.column-=2;return d.fromPoints(s.start,s.end)}else{continue}}if(s.closing){this._pop(q,s);if(q.length==0){return d.fromPoints(j,s.start)}}else{q.push(s)}}}else{var n=new h(o,r,l.column+l.match.length);var k={row:r,column:l.column};while(s=this._readTagBackward(n)){if(s.selfClosing){if(!q.length){s.start.column+=s.tagName.length+2;s.end.column-=2;return d.fromPoints(s.start,s.end)}else{continue}}if(!s.closing){this._pop(q,s);if(q.length==0){s.start.column+=s.tagName.length+2;return d.fromPoints(s.start,k)}}else{q.push(s)}}}}}).call(a.prototype)});ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(d,e,a){var h=d("../token_iterator").TokenIterator;var k=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","lang","spellcheck","style","tabindex","title","translate"];var l=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"];var j=k.concat(l);var f={html:["manifest"],head:[],title:[],base:["href","target"],link:["href","hreflang","rel","media","type","sizes"],meta:["http-equiv","name","content","charset"],style:["type","media","scoped"],script:["charset","type","src","defer","async"],noscript:["href"],body:["onafterprint","onbeforeprint","onbeforeunload","onhashchange","onmessage","onoffline","onpopstate","onredo","onresize","onstorage","onundo","onunload"],section:[],nav:[],article:["pubdate"],aside:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],header:[],footer:[],address:[],main:[],p:[],hr:[],pre:[],blockquote:["cite"],ol:["start","reversed"],ul:[],li:["value"],dl:[],dt:[],dd:[],figure:[],figcaption:[],div:[],a:["href","target","ping","rel","media","hreflang","type"],em:[],strong:[],small:[],s:[],cite:[],q:["cite"],dfn:[],abbr:[],data:[],time:["datetime"],code:[],"var":[],samp:[],kbd:[],sub:[],sup:[],i:[],b:[],u:[],mark:[],ruby:[],rt:[],rp:[],bdi:[],bdo:[],span:[],br:[],wbr:[],ins:["cite","datetime"],del:["cite","datetime"],img:["alt","src","height","width","usemap","ismap"],iframe:["name","src","height","width","sandbox","seamless"],embed:["src","height","width","type"],object:["param","data","type","height","width","usemap","name","form","classid"],param:["name","value"],video:["src","autobuffer","autoplay","loop","controls","width","height","poster"],audio:["src","autobuffer","autoplay","loop","controls"],source:["src","type","media"],track:["kind","src","srclang","label","default"],canvas:["width","height"],map:["name"],area:["shape","coords","href","hreflang","alt","target","media","rel","ping","type"],svg:[],math:[],table:["summary"],caption:[],colgroup:["span"],col:["span"],tbody:[],thead:[],tfoot:[],tr:[],td:["headers","rowspan","colspan"],th:["headers","rowspan","colspan","scope"],form:["accept-charset","action","autocomplete","enctype","method","name","novalidate","target"],fieldset:["disabled","form","name"],legend:[],label:["form","for"],input:["type","accept","alt","autocomplete","checked","disabled","form","formaction","formenctype","formmethod","formnovalidate","formtarget","height","list","max","maxlength","min","multiple","pattern","placeholder","readonly","required","size","src","step","width","files","value"],button:["autofocus","disabled","form","formaction","formenctype","formmethod","formnovalidate","formtarget","name","value","type"],select:["autofocus","disabled","form","multiple","name","size"],datalist:[],optgroup:["disabled","label"],option:["disabled","selected","label","value"],textarea:["autofocus","disabled","form","maxlength","name","placeholder","readonly","required","rows","cols","wrap"],keygen:["autofocus","challenge","disabled","form","keytype","name"],output:["for","form","name"],progress:["value","max"],meter:["value","min","max","low","high","optimum"],details:["open"],summary:[],command:["type","label","icon","disabled","checked","radiogroup","command"],menu:["type","label"],dialog:["open"]};var g=Object.keys(f);function c(n,o){var m=n.type.split(".");return o.split(".").every(function(p){return(m.indexOf(p)!==-1)})}function i(o,p){var n=new h(o,p.row,p.column);var m=n.getCurrentToken();if(!m||!c(m,"tag")&&!(c(m,"text")&&m.value.match("/"))){do{m=n.stepBackward()}while(m&&(c(m,"string")||c(m,"operator")||c(m,"attribute-name")||c(m,"text")))}if(m&&c(m,"tag-name")&&!n.stepBackward().value.match("/")){return m.value}}var b=function(){};(function(){this.getCompletions=function(o,p,q,n){var m=p.getTokenAt(q.row,q.column);if(!m){return[]}if(c(m,"tag-name")||(m.value=="<"&&c(m,"text"))){return this.getTagCompletions(o,p,q,n)}if(c(m,"text")||c(m,"attribute-name")){return this.getAttributeCompetions(o,p,q,n)}return[]};this.getTagCompletions=function(o,p,q,n){var m=g;if(n){m=m.filter(function(r){return r.indexOf(n)===0})}return m.map(function(r){return{value:r,meta:"tag"}})};this.getAttributeCompetions=function(p,q,r,o){var n=i(q,r);if(!n){return[]}var m=j;if(n in f){m=m.concat(f[n])}if(o){m=m.filter(function(s){return s.indexOf(o)===0})}return m.map(function(s){return{caption:s,snippet:s+'="$0"',meta:"attribute"}})}}).call(b.prototype);e.HtmlCompletions=b});ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/folding/coffee"],function(d,f,b){var g=d("../lib/oop");var e=d("./text").Mode;var h=d("../tokenizer").Tokenizer;var j=d("./ruby_highlight_rules").RubyHighlightRules;var k=d("./matching_brace_outdent").MatchingBraceOutdent;var c=d("../range").Range;var a=d("./folding/coffee").FoldMode;var i=function(){this.HighlightRules=j;this.$outdent=new k();this.foldingRules=new a()};g.inherits(i,e);(function(){this.lineCommentStart="#";this.getNextLineIndent=function(l,u,m){var n=this.$getIndent(u);var r=this.getTokenizer().getLineTokens(u,l);var s=r.tokens;if(s.length&&s[s.length-1].type=="comment"){return n}if(l=="start"){var q=u.match(/^.*[\{\(\[]\s*$/);var t=u.match(/^\s*(class|def)\s.*$/);var p=u.match(/.*do(\s*|\s+\|.*\|\s*)$/);var o=u.match(/^\s*(if|else)\s*/);if(q||t||p||o){n+=m}}return n};this.checkOutdent=function(n,l,m){return/^\s+end$/.test(l+m)||/^\s+}$/.test(l+m)||/^\s+else$/.test(l+m)};this.autoOutdent=function(n,o,p){var l=this.$getIndent(o.getLine(p));var m=o.getTabString();if(l.slice(-m.length)==m){o.remove(new c(p,l.length-m.length,p,l.length))}};this.$id="ace/mode/ruby"}).call(i.prototype);f.Mode=i});ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,e,b){var f=c("../lib/oop");var a=c("./text_highlight_rules").TextHighlightRules;var d=e.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};var l=e.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"};var g=e.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'};var h=e.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var j=e.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"};var i=e.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?\\b"};var k=function(){var p=("abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|validates_inclusion_of|validates_numericality_of|validates_with|validates_each|authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|cache|expire_fragment|expire_cache_for|observe|cache_sweeper|has_many|has_one|belongs_to|has_and_belongs_to_many");var o=("alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield");var m=("true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING");var q=("$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|$!|root_url|flash|session|cookies|params|request|response|logger|self");var n=this.$keywords=this.createKeywordMapper({keyword:o,"constant.language":m,"variable.language":q,"support.function":p,"invalid.deprecated":"debugger"},"identifier");this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment",regex:"^=begin(?:$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:"[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"},l,g,h,{token:"text",regex:"::"},{token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]+"},d,j,i,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:n,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(u,t,r){var s=u[2]=="-"?"indentedHeredoc":"heredoc";var v=u.split(this.splitRegex);r.push(s,v[3]);return[{type:"constant",value:v[1]},{type:"string",value:v[2]},{type:"support.class",value:v[3]},{type:"string",value:v[4]}]},regex:"(<<-?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(t,s,r){if(t===r[1]){r.shift();r.shift();this.next=r[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(t,s,r){if(t===r[1]){r.shift();r.shift();this.next=r[0]||"start";return"support.class"}this.next="";return"string"},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(s,r){if(r[0]==="heredoc"||r[0]==="indentedHeredoc"){return r[0]}return s}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],comment:[{token:"comment",regex:"^=end(?:$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}]};this.normalizeRules()};f.inherits(k,a);e.RubyHighlightRules=k});ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(b,a,c){var d=b("../../lib/oop");var g=b("./fold_mode").FoldMode;var f=b("../../range").Range;var e=a.FoldMode=function(){};d.inherits(e,g);(function(){this.getFoldWidgetRange=function(o,k,s){var m=this.indentationBlock(o,s);if(m){return m}var r=/\S/;var t=o.getLine(s);var l=t.search(r);if(l==-1||t[l]!="#"){return}var i=t.length;var p=o.getLength();var q=s;var j=s;while(++s<p){t=o.getLine(s);var h=t.search(r);if(h==-1){continue}if(t[h]!="#"){break}j=s}if(j>q){var n=o.getLine(j).length;return new f(q,i,j,n)}};this.getFoldWidget=function(n,j,o){var p=n.getLine(o);var h=p.search(/\S/);var k=n.getLine(o+1);var i=n.getLine(o-1);var l=i.search(/\S/);var m=k.search(/\S/);if(h==-1){n.foldWidgets[o-1]=l!=-1&&l<m?"start":"";return""}if(l==-1){if(h==m&&p[h]=="#"&&k[h]=="#"){n.foldWidgets[o-1]="";n.foldWidgets[o+1]="";return"start"}}else{if(l==h&&p[h]=="#"&&i[h]=="#"){if(n.getLine(o-2).search(/\S/)==-1){n.foldWidgets[o-1]="start";n.foldWidgets[o+1]="";return""}}}if(l!=-1&&l<h){n.foldWidgets[o-1]="start"}else{n.foldWidgets[o-1]=""}if(h<m){return"start"}else{return""}}}).call(e.prototype)});